/**
* \file: WaylandTouchInput.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Digital iPod Out - Wayland Adapter
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef DIPO_WAYLANDTOUCHINPUT_H
#define DIPO_WAYLANDTOUCHINPUT_H

#include <memory>
#include <dipo_plugin.h>
#include "WaylandContext.h"
#include "WaylandSurface.h"

LOG_IMPORT_CONTEXT(dipo_wl);

namespace adit { namespace carplay
{
class HIDDigitizer;

class DIPO_WL_EXPORTED_SYMBOL WaylandTouchInput : public IInputAdapter
{
public:
    WaylandTouchInput();
    virtual ~WaylandTouchInput();

    bool Initialize(const IConfiguration& inConfig, IInputReceiver& inReceiver, SessionId inSessionId);

private:
    IInputReceiver* receiver;

    WaylandContext* wayland;
    WaylandSurface* surface;
    HIDDigitizer* digitizer;

    void release();

    static WaylandTouchInput* current;
};

} } /* namespace adit { namespace carplay */

#endif /* DIPO_WAYLANDTOUCHINPUT_H */
